import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/helper/date_converter.dart';
import 'package:viserpay/core/helper/string_format_helper.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/data/controller/auto_payment/auto_payment_controller.dart';
import 'package:viserpay/data/model/auto_payment/auto_paymet_response_model.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:viserpay/view/components/bottom-sheet/bottom_sheet_bar.dart';
import 'package:viserpay/view/components/bottom-sheet/bottom_sheet_close_button.dart';
import 'package:viserpay/view/components/column_widget/card_column.dart';
import 'package:viserpay/view/components/divider/custom_divider.dart';
import 'package:viserpay/view/components/text/bottom_sheet_header_text.dart';

class AutoPaymentSendMoneyBottomSheet extends StatelessWidget {
  const AutoPaymentSendMoneyBottomSheet({super.key, required this.item});
  final AutoPaymentHistoryData item;
  @override
  Widget build(BuildContext context) {
    return GetBuilder<AutoPaymentController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const BottomSheetBar(),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [BottomSheetHeaderText(text: MyStrings.details.tr), const BottomSheetCloseButton()],
          ),
          const CustomDivider(space: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              CardColumn(
                header: MyStrings.receiverUser.tr,
                body: item.receiver?.getFullName() ?? "",
              ),
              CardColumn(
                alignmentEnd: true,
                header: MyStrings.date.tr,
                body: DateConverter.convertIsoToString(item.createdAt ?? ""),
              )
            ],
          ),
          const SizedBox(height: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              CardColumn(header: MyStrings.phone.tr, body: "+${item.receiver?.dialCode ?? ""}${item.receiver?.mobile ?? ""}"),
              CardColumn(
                header: MyStrings.amount.tr,
                body: "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${StringConverter.formatNumber(item.amount ?? "")} ",
                alignmentEnd: true,
              ),
            ],
          ),
          const SizedBox(height: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              CardColumn(
                header: MyStrings.nextAutoPaymentDate.tr,
                body: DateConverter.estimatedDate(item.nextPayment ?? DateTime.now()),
              ),
            ],
          ),
          const SizedBox(height: Dimensions.space25),
          GestureDetector(
              onTap: () {
                if (!controller.isDeleteAutoPayLoading) {
                  controller.deleteAutoPay(item.id.toString());
                }
              },
              child: Container(
                width: MediaQuery.of(context).size.width,
                alignment: Alignment.center,
                padding: const EdgeInsets.symmetric(vertical: Dimensions.space12),
                decoration: BoxDecoration(
                    border: Border.all(
                      color: MyColor.redCancelTextColor,
                    ),
                    borderRadius: BorderRadius.circular(Dimensions.defaultRadius)),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    if (controller.isDeleteAutoPayLoading) ...[
                      SizedBox(
                        height: Dimensions.space25,
                        width: Dimensions.space25,
                        child: CircularProgressIndicator(
                          strokeWidth: 2,
                          color: MyColor.redCancelTextColor,
                        ),
                      ),
                    ] else ...[
                      Text(
                        MyStrings.delete.tr,
                        style: regularDefault.copyWith(color: MyColor.redCancelTextColor),
                      )
                    ]
                  ],
                ),
              )),
        ],
      ),
    );
  }
}
